import Phaser from 'phaser';
import { useEffect, useState } from 'react';

const GAME_WIDTH = 1920;
const GAME_HEIGHT = 1080;

let graphics;
let gameData;

function preload()
{

}

function create()
{
  graphics = this.add.graphics({ lineStyle: { width: 2, color: 0x00ff00 }, fillStyle: { color: 0xff00ff } });
}

function update() 
{
  graphics.clear();
	
	//graphics.lineStyle(2, 0x00ff00);
	//graphics.strokeCircle(50, 50, 10);

  //console.log(gameData);
  if(gameData && gameData.data)
  {
    let minX = 0, minY = 0;
    if(gameData.data.tiles && gameData.data.tiles.length > 0)
    {
      minX = gameData.data.tiles[0][0];
      minY = gameData.data.tiles[0][1];
      for(const tile of gameData.data.tiles)
      {
        if(minX > tile[0]) minX = tile[0];
        if(minY > tile[1]) minY = tile[1];
      }

      for(const tile of gameData.data.tiles)
      {
        let col = 0xffffff;
        switch(tile[2])
        {
          case 1: col = 0xffffff; break;
          case 2: col = 0x444444; break;
          case 3: col = 0x888888; break;
          case 4: col = 0xaaaaaa; break;
          case 5: col = 0x0000ff; break;
          case 6: col = 0x0000ff; break;
          case 7: col = 0x0000ff; break;
          case 9: col = 0xffff00; break;
          default: break;
        }
        graphics.lineStyle(2, col);
        graphics.strokeRect((tile[0]-minX)/5 + 50, (tile[1]-minY)/5 + 50, 20, 20);
      }

      if(gameData.data.player)
      {
        graphics.lineStyle(2, 0x00ff00);
        graphics.strokeCircle((gameData.data.player[0]-minX)/5 + 50, (gameData.data.player[1]-minY)/5 + 50, 8);
      }

      if(gameData.data.bunnies)
      {
        for(const bunny of gameData.data.bunnies)
        {
          graphics.lineStyle(2, 0xff0000);
          graphics.strokeCircle((bunny[0]-minX)/5 + 50, (bunny[1]-minY)/5 + 50, 8);
        }
      }
    }
  }
	
	graphics.lineStyle(4, 0xffffff);
	graphics.strokeRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
}

const gameConfig = {
  width: GAME_WIDTH,
  height: GAME_HEIGHT,
  type: Phaser.AUTO,
  parent: 'game',
  backgroundColor: '#183936',
  physics: {
		default: 'arcade',
		arcade: {
			debug: true
		}
  },
  scale: {
    mode: Phaser.Scale.FIT,
    autoCenter: Phaser.Scale.CENTER_BOTH
  },
  scene: {
		preload: preload,
		create: create,
		update: update
	},
}

const Game = () => {

  const [game, setGame] = useState(undefined);
  const [gameCfg] = useState(gameConfig);

  const loadData = () => {
    fetch(`${process.env.PUBLIC_URL}/games` + window.location.search)
      .then(response => response.json())
      .then(data => { gameData = data; });
  };

  useEffect(() => {
    // ja nu sagribās refreshot spēli uz katru labojumu:
    /*if(game) {
      console.log("destroying old game");
      game.destroy(true, false);
    }
    console.log("creating new game");
    setGame(new Phaser.Game(gameCfg));*/

    if(!game) {
      setGame(new Phaser.Game(gameCfg));
    }

    const intervalId = setInterval(() => {
      loadData();
    }, 1000);
    loadData();

    return () => {
      if(game) game.destroy(true, false);
      clearInterval(intervalId);
    };
  }, [game, gameCfg]);

  return (
    <div className="wrapper">
      <div id="game" className="game"></div>
    </div>
  );
}

export default Game;
